function [res]=PWM_test(skt1);
udpset(skt1,'PWM_On',[0 0]);
PWM_Val=udpget(skt1,'PWM_Val');
if (!PWM_Val==[0 0]) error('PWM_Val not [0 0] initially - Test1 failed')else printf('Test1 Passed\n');end
udpset(skt1,'PWM_On',[1 1]);
PWM_Max=udpget(skt1,'PWM_Max');
PWM_Val=udpget(skt1,'PWM_Val');
if (!PWM_Val==PWM_Max) error('PWM_Val not PWM_MAX after setting PWM_On to [ 1 1]- Test2 failed'); else printf('Test2 Passed\n');end
udpset(skt1,'PWM_On',[0 0]);
PWM_Val=udpget(skt1,'PWM_Val');
if (!PWM_Val==[0 0]) error('PWM_Val not [0 0] cleared - Test3 failed') else printf('Test3 Passed\n');end

d=udpget(skt1,'command_vec');
c_bytes=max(size(d));
udp_pwm_command_poke(skt1,1,zeros(c_bytes,1));
d=udpget(skt1,'command_vec');
if (!(d==zeros(c_bytes,1))) error('command_vec not  cleared - Test4 failed') else printf('Test4 Passed\n');end
d=udpget(skt1,'command_vec_buffer');
if (!(d==zeros(c_bytes,1))) error('command_vec_buffer not  cleared - Test5 failed')else printf('Test5 Passed\n');end
udpset(skt1,'command_vec_buffer',1:c_bytes);
d=udpget(skt1,'command_vec_buffer');
if (!(d==1:c_bytes)) error('command_vec_buffer not  set 1:64 - Test6 failed') else printf('Test6 Passed\n');end
d=udpget(skt1,'command_vec');
if (!(d==zeros(c_bytes,1))) error('command_vec_buffer not  set 1:64 - Test7 failed') else printf('Test7 Passed\n');end
udp_pwm_command_poke(skt1,1,100);
d=udpget(skt1,'command_vec');
if (!(d==[100 zeros(c_bytes-1,1)'] )) error('command_vec_buffer not fire set [100 1:64] - Test8 failed')else printf('Test8 Passed\n');end

udp_pwm_command_poke(skt1,1,zeros(c_bytes,1));

%assumes card at op 1.254
% box is 15, card is 15 and gen is 0 or 1
%Start with gen 0
box=15;
card=15;
gen=0;

idx=box*4+floor(card/4);

ip=box*32+card*2;
bit=(((card/4)-floor(card/4))*8)+gen;
d=zeros(64,1);
d(idx+1)=2^bit;

udp_pwm_command_poke(skt1,1,d);
PWM_Val=udpget(skt1,'PWM_Val');
if (!(PWM_Val==[PWM_Max 0])) error('PWM_Val not PWM_MAX after setting bit using udp_pwm_command_poke- Test9 failed'); else printf('Test9 Passed\n');end

% Now with gen 1
box=15;
card=15;
gen=1;

idx=box*4+floor(card/4);

ip=box*32+card*2;
bit=(((card/4)-floor(card/4))*8)+gen;
d=zeros(64,1);
d(idx+1)=2^bit;

udp_pwm_command_poke(skt1,1,d);
PWM_Val=udpget(skt1,'PWM_Val');
if (!(PWM_Val==[0 PWM_Max ])) error('PWM_Val not PWM_MAX after setting bit using udp_pwm_command_poke- Test10 failed'); else printf('Test10 Passed\n');end
% Turn the gens off
udp_pwm_command_poke(skt1,1,zeros(c_bytes,1));

res='All Tests Passed';



